/***********************************************************************************************\
* Freescale MMA845xQ Driver
*
* Filename: mma845x.c
*
* Description: Driver source file for Freescale MMA851Q, MMA8452Q and MMA8453Q accelerometers
*
* (c) Copyright 2011, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
\***********************************************************************************************/

#include "system.h"

/***********************************************************************************************\
* Private macros
\***********************************************************************************************/

/***********************************************************************************************\
* Private type definitions
\***********************************************************************************************/

/***********************************************************************************************\
* Private prototypes
\***********************************************************************************************/

/***********************************************************************************************\
* Private memory declarations
\***********************************************************************************************/

/***********************************************************************************************\
* Public memory declarations
\***********************************************************************************************/

#pragma DATA_SEG __SHORT_SEG _DATA_ZEROPAGE

extern byte SlaveAddressIIC;

#pragma DATA_SEG DEFAULT

/***********************************************************************************************\
* Public functions
\***********************************************************************************************/

/*********************************************************\
* Put MMA845xQ into Active Mode
\*********************************************************/
void MMA845x_Active (void)
{
  /*
  ** Set the Active bit in System Control 1 Register.
  */
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG1, (IIC_RegRead(SlaveAddressIIC, CTRL_REG1) | ACTIVE_MASK));
}


/*********************************************************\
* Put MMA845xQ into Standby Mode
\*********************************************************/
byte MMA845x_Standby (void)
{
  byte n;
  //Read current value of System Control 1 Register.
  n = IIC_RegRead(SlaveAddressIIC, CTRL_REG1);
  //Put sensor into Standby Mode by clearing the Active bit. 
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG1, n & (~ACTIVE_MASK)); 
  //Return with previous value of System Control 1 Register.
  return (n & ACTIVE_MASK);   
}


/*********************************************************\
* Initialize MMA845xQ
\*********************************************************/
void MMA845x_Init (void)
{
  byte n;
  /*
  **  Reset sensor, and wait for reboot to complete
  */
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG2, RST_MASK);
  do {
    n = IIC_RegRead(SlaveAddressIIC, CTRL_REG2);
  } while (n & RST_MASK);
  /*
  **  Configure sensor for:
  **    - Sleep Mode Poll Rate of 50Hz (20ms)
  **    - System Output Data Rate of 200Hz (5ms)
  **    - Full Scale of +/-8g
  */
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG1, ASLP_RATE_20MS + DATA_RATE_5MS);
  /*
  **  Configure sensor data for:
  **    - Full Scale of +/-8g
  **
  **  XYZ Data Event Flag Enable
  */
  IIC_RegWrite(SlaveAddressIIC, XYZ_DATA_CFG_REG, FULL_SCALE_8G);
  
  IIC_RegWrite(SlaveAddressIIC, 0x15, 0x78);
  IIC_RegWrite(SlaveAddressIIC, 0x17, 0x0F);
  IIC_RegWrite(SlaveAddressIIC, 0x18, 0x09);
  IIC_RegWrite(SlaveAddressIIC, 0x2C, 0x01);
  IIC_RegWrite(SlaveAddressIIC, 0x2D, 0x04);
  IIC_RegWrite(SlaveAddressIIC, 0x2E, 0x04);
  IIC_RegWrite(SlaveAddressIIC, 0x2A, 0x11);  
  //Sony Register Configuration
  /*IIC_RegWrite(SlaveAddressIIC, 0x2A, 0x2C);
  IIC_RegWrite(SlaveAddressIIC, 0x2B, 0x02);
  IIC_RegWrite(SlaveAddressIIC, 0x15, 0xB8);
  IIC_RegWrite(SlaveAddressIIC, 0x17, 0x83);                
  IIC_RegWrite(SlaveAddressIIC, 0x18, 0x30);
  IIC_RegWrite(SlaveAddressIIC, 0x2C, 0x00);
  IIC_RegWrite(SlaveAddressIIC, 0x2D, 0x04);
  IIC_RegWrite(SlaveAddressIIC, 0x2E, 0x04);
  IIC_RegWrite(SlaveAddressIIC, 0x2A, 0x2D);  //LNOISE Mode    */
  
  //IIC_RegWrite(SlaveAddressIIC, 0x2A, 0x29);   //Normal Mode 
  
  
}


/***********************************************************************************************\
* Private functions
\***********************************************************************************************/
